"use client";
import Link from "next/link";
import React, { useState } from "react";
import Image from "next/image";
import finalLogo from "../../../../public/assets/navbar/finalLogo.png";
import MobileView from "./MobileView";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faXmark, faBars } from "@fortawesome/free-solid-svg-icons";
import { usePathname, useRouter } from "next/navigation";
import Cookies from "js-cookie";
import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";
import { userLogout } from "@/redux/authSlice";
import { useLogoutUserMutation } from "@/services/Api";
import { BASE_URL_ADMIN } from "@/services/ApiEndpoints";
import { BASE_URL } from "@/services/ApiEndpoints";

function Navbar() {
  const dispatch = useDispatch();
  const router = useRouter();
  const pathname = usePathname();
  const linkClasses = (path) =>
    `flex gap-3 py-2 ${
      pathname.startsWith(path)
        ? "bg-[#F5F5F5] rounded text-golden"
        : "text-[#484F61]"
    }`;
  const [coursesOpen, setCourseOpen] = useState(false);
  const [menuOpen, setMenuOpen] = useState(false);
  const auth = useSelector((data) => data?.auth);

  const toggleMenu = () => {
    setMenuOpen(!menuOpen);
  };

  const [logoutUser] = useLogoutUserMutation();

  const handleLogout = () => {
    dispatch(userLogout(null));
    router.push("/");
    Cookies.remove("role");
    Cookies.remove("authToken");
    localStorage.clear();
    logoutUser()
      .unwrap()
      .then(() => {
        dispatch(userLogout(null));
        router.push("/");
        Cookies.remove("role");
        Cookies.remove("authToken");
        localStorage.clear();
        toast.success("Logout Successful", {
          position: "top-center",
        });
      })
      .catch((error) => {});
  };

  return (
    <header className="bg-white fixed w-full z-50 shadow-lg">
      <div
        className="relative mx-auto flex max-w-7xl items-center justify-between h-[100px] lg:h-[120px] lg:px-8 px-4"
        aria-label="Global"
      >
        <div className="flex lg:flex">
          <Link href="/" className="-m-1.5 p-1.5">
            <span className="sr-only">Your Company</span>
            <Image
              className="h-[95px] lg:h-[107px] w-[131px]"
              src={finalLogo}
              alt="main-logo"
            />
          </Link>
        </div>

        <div className="flex lg:hidden">
          <button
            type="button"
            className="-m-2.5 inline-flex items-center justify-center rounded-md p-2.5 text-gray-700"
            onClick={toggleMenu}
          >
            <span className="sr-only">Open main menu</span>
            {menuOpen ? (
              <FontAwesomeIcon icon={faXmark} />
            ) : (
              <FontAwesomeIcon icon={faBars} />
            )}
          </button>
        </div>

        <div className="hidden h-full lg:flex lg:gap-x-6">
          <div className="flex justify-center items-center">
            <Link
              href="/"
              className={`text-sm font-semibold leading-6 px-4 py-2 ${
                pathname === "/"
                  ? "bg-[#F5F5F5] rounded text-golden"
                  : "text-[#484F61]"
              }`}
            >
              Home
            </Link>
          </div>
          <div className="flex justify-center items-center">
            <Link
              href="/about"
              className={`text-sm font-semibold leading-6 px-4 ${linkClasses(
                "/about"
              )}`}
            >
              About
            </Link>
          </div>
          <div className="relative flex">
            <div
              className="flex justify-center items-center"
              onMouseEnter={() => setCourseOpen(true)}
              onMouseLeave={() => setCourseOpen(false)}
            >
              <Link
                href="/course"
                className={`flex items-center text-sm font-semibold leading-6 px-3 ${linkClasses(
                  "/course"
                )}`}
              >
                Courses
                {/* <FontAwesomeIcon icon={faAngleDown} /> */}
              </Link>
            </div>
            {/* {coursesOpen && (
              <div
                className="absolute -left-8 top-20 z-10 mt-3 w-screen max-w-md overflow-hidden rounded-3xl bg-white shadow-lg ring-1 ring-gray-900/5"
                onMouseEnter={() => setCourseOpen(true)}
                onMouseLeave={() => setCourseOpen(false)}
              >
                <CoursesPage />
              </div>
            )} */}
          </div>
          <div className="flex justify-center items-center">
            <Link
              href="/certificates"
              className={`text-sm font-semibold leading-6 px-3 ${linkClasses(
                "/certificates"
              )}`}
            >
              Certifications
            </Link>
          </div>
          <div className="flex justify-center items-center">
            <Link
              href="/blog"
              className={`text-sm font-semibold leading-6 px-3 ${linkClasses(
                "/blog"
              )}`}
            >
              Blog
            </Link>
          </div>
        </div>

        <div className="hidden lg:flex lg:justify-end items-center gap-7 h-full">
          <div className="flex gap-2">
            {auth?.isLoggedIn && auth?.userDetail ? (
              <div className="flex gap-2">
                {auth?.userDetail?.role?.name === "admin" ? (
                  <Link
                    href={`${BASE_URL_ADMIN}dashboard`}
                    className="text-sm font-semibold leading-6 text-gray-900 flex items-center"
                  >
                    Dashboard
                  </Link>
                ) : (
                  <Link
                    href={`/dashboard`}
                    className="text-sm font-semibold leading-6 text-gray-900 flex items-center"
                  >
                    Dashboard
                  </Link>
                )}

                <p className="text-sm font-semibold leading-6 text-gray-900 flex items-center">
                  /
                </p>
                <button
                  onClick={handleLogout}
                  className="text-sm font-semibold leading-6 text-gray-900 flex items-center"
                >
                  Log out
                </button>
              </div>
            ) : (
              <div className="flex gap-2">
                <Link
                  href="/login"
                  className="text-sm font-semibold leading-6 text-gray-900 flex items-center gap-3"
                >
                  Log in
                </Link>
                <p className="text-sm font-semibold leading-6 text-gray-900 flex items-center gap-3">
                  /
                </p>
                <Link
                  href="/sign-up"
                  className="text-sm font-semibold leading-6 text-gray-900 flex items-center gap-3"
                >
                  Register
                </Link>
              </div>
            )}
            {/* <span className="border border-[#B9802A] py-3 px-4 rounded-full">
              <FontAwesomeIcon
                icon={faMagnifyingGlass}
                className="text-golden"
              />
            </span> */}
          </div>
          <Link
            href="/login"
            className="text-sm font-semibold leading-6 bg-golden py-3 px-4 rounded-[30px] text-[#FFFFFF]"
          >
            Full Course Access
          </Link>
        </div>
      </div>

      {menuOpen && (
        <div className="absolute lg:hidden w-full bg-white px-6 top-[100px] z-50">
          <MobileView toggleMenu={toggleMenu} />
        </div>
      )}
    </header>
  );
}

export default Navbar;
